function out = fct_process_data_for_estimation(data, lambda)

% % % DESCRIPTION
% % % This function symmetrizes the data and smoothes it using smoothing
% % % parameter lambda.
% % % INPUT
% % % data -- data on complete spells only
% % % lambda -- smoothing parameter
% % % OUTPUT
% % % data_smooth -- symmetric smoothed data
% % % data_sym    -- symmetric data, not smoothed

% ADD MISSING OBSERVATIONS
    Tsym_min = min(min(data(:,1:2)));
    Tsym_max = max(max(data(:,1:2)));   
    data_extend = fct_add_missing_obs(data(:,1:3),Tsym_min,Tsym_max,Tsym_min,Tsym_max);

% SYMMETRIZE DATA
    N    = Tsym_max-Tsym_min+1;
    TEMP = reshape(data_extend(:,3),N,N);
    TEMP = (TEMP+TEMP')/2;
    data_extend(:,3) = TEMP(:); 

% RUN HP-FILTER
    B   = log(1+data_extend(:,3));
    %B = max(data_extend(:,3),0.5);
    %B = log(B);
    phi = reshape(B,N,N);
    phi_smooth = fct_HP_2dim_triangular(phi,lambda);
    smooth_reshape_log = reshape(phi_smooth,N*N,1);
    smooth_reshape = exp(smooth_reshape_log);
    
    data_smooth = zeros(N*N,3);
    data_smooth(:,1) = data_extend(:,1);
    data_smooth(:,2) = data_extend(:,2);
    data_smooth(:,3) = smooth_reshape;        
    data_smooth = data_smooth.*(data_smooth>0);    
    
% OUTPUT    
    out.data_smooth = data_smooth;
    out.data_sym = data_extend;    
    
return
